//	header file for an autonomous sound that plays itself
#pragma once

class CMSound;							//	forward declaration

#include <MediaKit.h>
#include "CMSemaphore.h"

class CMSound : public BSubscriber			//	declare it as a subclass of subscriber
	{
	private:
	char *theSoundData;					//	the sampled data
	char *framePointer;					//	pointer to the "current" frame
	char *tailEnd;						//	pointer to the tail end of the sound data
	CMSemaphore *alreadyPlaying;			//	mutex semaphore
	BDACStream *the_audio_stream;			//	pointer to the BeOS audio stream
	
	public:
	CMSound(char *newSoundData, char *soundName, long soundLength);
									//	constructor that takes 
									//	a pointer to the sound data
	
	~CMSound();						//	destructor - releases the sound

	static bool _play_back(void *arg, char *sound, size_t size, void *header);
									//	this is a glue function handed to the system
	bool Playback(char *sound, long nBytes);//	this is called by the system to play each chunk
	
	void Play();						//	plays the sound once
	static long _done_playing(void *arg, long error);
									//	glue code for DonePlaying
	void DonePlaying();					//	cleans up when done
	}; // end of class CMSound